if ('scrollRestoration' in history) {
    history.scrollRestoration = 'manual';
}
const scrollContainer = document.getElementById("js-scroll");
const locoScroll = new LocomotiveScroll({
    el: scrollContainer,
    smooth: true,
    lerp: 0.1,
});

document.addEventListener('DOMContentLoaded', () => {

    const locoScroll = new LocomotiveScroll({
        el: scrollContainer,
        smooth: true,
        lerp: 0.1,
    });

    locoScroll.scrollTo(0, {
        duration: 0,
        disableLerp: true,
    });
    const backToTop = document.getElementById("templaza-backtotop");
    const backToTopEl = document.getElementById("templaza-backtotop-element");
    const footer = document.querySelector('.templaza-footer');
    locoScroll.on("scroll", (args) => {

        const scrollY = args.scroll.y;
        const footerTop = footer.offsetTop+250;
        const viewportHeight = window.innerHeight;
        const isOver500 = scrollY > 200;
        const isInFooterView = scrollY + viewportHeight >= footerTop;

        if (isOver500 && !isInFooterView) {
            backToTop.style.display = "inline";
        } else {
            backToTop.style.display = "none";
        }

    });

    backToTop.addEventListener("click", () => {
        locoScroll.scrollTo(0, {
            duration: 800,
            disableLerp: false
        });
    });
    backToTopEl.addEventListener("click", () => {
        locoScroll.scrollTo(0, {
            duration: 800,
            disableLerp: false
        });
    });
});



window.addEventListener('load', () => {
    window.scrollTo(0, 0);
    setTimeout(() => {
        locoScroll.update();
        locoScroll.scrollTo(0, { duration: 0, disableLerp: true });
    }, 100);
});

function splitLineText(){
    splitLines = new SplitText(".sc_heading .heading-plain-text", {
        type: "lines",
        linesClass: "text-lines"
    });
}
// Back to Top button logic


function setup() {
    splitLineText();
    locoScroll.on("scroll", ScrollTrigger.update);

    ScrollTrigger.addEventListener("refresh", () => locoScroll.update());

    ScrollTrigger.refresh();
}
if (document.querySelector('.tz_background_overlay')) {
    const container = document.querySelector('.tz_background_overlay');

    let mouseX = 0;
    let mouseY = 0;
    let rect = container.getBoundingClientRect();
    let isHovering = false;

    container.addEventListener('mouseenter', () => {
        rect = container.getBoundingClientRect();
        isHovering = true;
    });

    container.addEventListener('mousemove', (e) => {
        mouseX = e.clientX - rect.left;
        mouseY = e.clientY - rect.top;
    });

    container.addEventListener('mouseleave', () => {
        isHovering = false;
        // overlay.style.background = 'none';
        container.style.backgroundPosition = 'center';
    });

    function animate() {
        if (isHovering) {
            // Làm mượt di chuyển background
            const percentX = (mouseX / rect.width - 0.5) * 20;
            const percentY = (mouseY / rect.height - 0.5) * 20;
            container.style.backgroundPosition = `${50 + percentX}% ${50 + percentY}%`;
        }

        requestAnimationFrame(animate);
    }

    animate();
}

setup();
window.addEventListener("resize", setup);

const thumbnails = document.querySelectorAll('.tz-img, .product-thumbnails--hover');

thumbnails.forEach(thumbnail => {
    let currentX = 0, currentY = 0;
    let targetX = 0, targetY = 0;
    let rafId = null;

    function animate() {
        currentX += (targetX - currentX) * 0.1;
        currentY += (targetY - currentY) * 0.1;

        thumbnail.style.transform = `translate(${currentX}px, ${currentY}px)`;

        if (Math.abs(targetX - currentX) > 0.1 || Math.abs(targetY - currentY) > 0.1) {
            rafId = requestAnimationFrame(animate);
        } else {
            rafId = null; // animation kết thúc, cho phép gọi lại lần sau
        }
    }

    thumbnail.addEventListener('mousemove', (e) => {
        const rect = thumbnail.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;

        targetX = (x / rect.width - 0.5) * 20;
        targetY = (y / rect.height - 0.5) * 20;

        if (!rafId) {
            animate();
        }
    });

    thumbnail.addEventListener('mouseleave', () => {
        targetX = 0;
        targetY = 0;
        if (!rafId) {
            animate();
        }
    });
});
